using System;
using System.Collections;
using System.ComponentModel;
using System.Drawing;
using System.Data;
using System.Windows.Forms;

namespace gov.va.med.vbecs.GUI.controls
{
	/// <summary>
	/// Summary description for PatientSpecimenDisplayPanel.
	/// </summary>
	public class PatientSpecimenDisplayPanel : GUI.controls.BaseControl
	{
		#region Variables

		private BOL.Specimen _specimen;
		private BOL.Patient _patient;
		#endregion

		#region Events

		private System.EventHandler onSIAndTRClick;
		private System.EventHandler onBloodAvailClick;
		private System.EventHandler onVbecsInfoClick;
		private System.EventHandler onMedicationsClick;
		private System.EventHandler onTransHistoryClick;
		private System.EventHandler onClinicalInfoClick;
		
		#endregion

		#region Controls

		private System.Windows.Forms.GroupBox grpPatient;
		private System.Windows.Forms.Label label5;
		private System.Windows.Forms.Label label6;
		private System.Windows.Forms.TextBox txtABORh;
		private System.Windows.Forms.Label lblABORh;
		private System.Windows.Forms.Label lblSSN;
		private System.Windows.Forms.Label lblName;
		private System.Windows.Forms.GroupBox grpImage;
		private System.Windows.Forms.PictureBox pictureBox1;
		private gov.va.med.vbecs.GUI.controls.PatientInfoToolbar patientInfoToolbar1;
		private System.Windows.Forms.TextBox txtName;
		private System.Windows.Forms.TextBox txtExpires;
		private System.Windows.Forms.TextBox txtSpecimenID;
		private System.Windows.Forms.TextBox txtPatientID;
		private System.Windows.Forms.ToolTip toolTip1;
		private System.Windows.Forms.PictureBox picJustified;
		private System.Windows.Forms.PictureBox pictureBox2;
		private System.ComponentModel.IContainer components;

		#endregion


		#region Constructors

		/// <summary>
		/// Constructor
		/// </summary>
		public PatientSpecimenDisplayPanel()
		{
			// This call is required by the Windows.Forms Form Designer.
			InitializeComponent();

			this.patientInfoToolbar1.SingleRowDisplay = true;

		}

		/// <summary>
		/// Constructor
		/// </summary>
		/// <param name="specimen"></param>
		public PatientSpecimenDisplayPanel(BOL.Specimen specimen) : this()
		{
			this._specimen = specimen;
			this._patient = specimen.Patient;
		}

		/// <summary> 
		/// Clean up any resources being used.
		/// </summary>
		protected override void Dispose( bool disposing )
		{
			if( disposing )
			{
				if(components != null)
				{
					components.Dispose();
				}
			}
			base.Dispose( disposing );
		}

		#endregion

		#region Component Designer generated code
		/// <summary> 
		/// Required method for Designer support - do not modify 
		/// the contents of this method with the code editor.
		/// </summary>
		private void InitializeComponent()
		{
			this.components = new System.ComponentModel.Container();
			System.Resources.ResourceManager resources = new System.Resources.ResourceManager(typeof(PatientSpecimenDisplayPanel));
			this.grpPatient = new System.Windows.Forms.GroupBox();
			this.picJustified = new System.Windows.Forms.PictureBox();
			this.patientInfoToolbar1 = new gov.va.med.vbecs.GUI.controls.PatientInfoToolbar();
			this.txtName = new System.Windows.Forms.TextBox();
			this.txtExpires = new System.Windows.Forms.TextBox();
			this.label5 = new System.Windows.Forms.Label();
			this.txtSpecimenID = new System.Windows.Forms.TextBox();
			this.label6 = new System.Windows.Forms.Label();
			this.txtABORh = new System.Windows.Forms.TextBox();
			this.lblABORh = new System.Windows.Forms.Label();
			this.txtPatientID = new System.Windows.Forms.TextBox();
			this.lblSSN = new System.Windows.Forms.Label();
			this.lblName = new System.Windows.Forms.Label();
			this.grpImage = new System.Windows.Forms.GroupBox();
			this.pictureBox2 = new System.Windows.Forms.PictureBox();
			this.pictureBox1 = new System.Windows.Forms.PictureBox();
			this.toolTip1 = new System.Windows.Forms.ToolTip(this.components);
			this.grpPatient.SuspendLayout();
			this.grpImage.SuspendLayout();
			this.SuspendLayout();
			// 
			// grpPatient
			// 
			this.grpPatient.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.grpPatient.Controls.Add(this.picJustified);
			this.grpPatient.Controls.Add(this.patientInfoToolbar1);
			this.grpPatient.Controls.Add(this.txtName);
			this.grpPatient.Controls.Add(this.txtExpires);
			this.grpPatient.Controls.Add(this.label5);
			this.grpPatient.Controls.Add(this.txtSpecimenID);
			this.grpPatient.Controls.Add(this.label6);
			this.grpPatient.Controls.Add(this.txtABORh);
			this.grpPatient.Controls.Add(this.lblABORh);
			this.grpPatient.Controls.Add(this.txtPatientID);
			this.grpPatient.Controls.Add(this.lblSSN);
			this.grpPatient.Controls.Add(this.lblName);
			this.grpPatient.Location = new System.Drawing.Point(44, 0);
			this.grpPatient.Name = "grpPatient";
			this.grpPatient.Size = new System.Drawing.Size(620, 64);
			this.grpPatient.TabIndex = 0;
			this.grpPatient.TabStop = false;
			// 
			// picJustified
			// 
			this.picJustified.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.picJustified.Image = ((System.Drawing.Image)(resources.GetObject("picJustified.Image")));
			this.picJustified.Location = new System.Drawing.Point(594, 14);
			this.picJustified.Name = "picJustified";
			this.picJustified.Size = new System.Drawing.Size(16, 16);
			this.picJustified.SizeMode = System.Windows.Forms.PictureBoxSizeMode.AutoSize;
			this.picJustified.TabIndex = 61;
			this.picJustified.TabStop = false;
			this.toolTip1.SetToolTip(this.picJustified, "The patient has a history of  justified ABO/Rh change");
			this.picJustified.Visible = false;
			// 
			// patientInfoToolbar1
			// 
			this.patientInfoToolbar1.AccessibleDescription = "Patient Information Toolbar";
			this.patientInfoToolbar1.AccessibleName = "Patient Information Toolbar";
			this.patientInfoToolbar1.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.patientInfoToolbar1.EnabledBloodAvailButton = false;
			this.patientInfoToolbar1.EnabledMedicationButton = false;
			this.patientInfoToolbar1.EnabledRecentOrdersButton = false;
			this.patientInfoToolbar1.EnabledRecentTransfusionsIssuesButton = false;
			this.patientInfoToolbar1.EnabledSIAndTRButton = false;
			this.patientInfoToolbar1.EnabledTransfusionReactionHistoryButton = false;
			this.patientInfoToolbar1.Location = new System.Drawing.Point(458, 36);
			this.patientInfoToolbar1.Name = "patientInfoToolbar1";
			this.patientInfoToolbar1.ParentFormInstanceGuid = new System.Guid("00000000-0000-0000-0000-000000000000");
			this.patientInfoToolbar1.Patient = null;
			this.patientInfoToolbar1.Size = new System.Drawing.Size(154, 20);
			this.patientInfoToolbar1.TabIndex = 6;
			// 
			// txtName
			// 
			this.txtName.AccessibleDescription = "Name";
			this.txtName.AccessibleName = "Name";
			this.txtName.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtName.Cursor = System.Windows.Forms.Cursors.Arrow;
			this.txtName.Location = new System.Drawing.Point(80, 12);
			this.txtName.Name = "txtName";
			this.txtName.ReadOnly = true;
			this.txtName.Size = new System.Drawing.Size(196, 20);
			this.txtName.TabIndex = 1;
			this.txtName.Text = "";
			// 
			// txtExpires
			// 
			this.txtExpires.AccessibleDescription = "Expires";
			this.txtExpires.AccessibleName = "Expires";
			this.txtExpires.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.txtExpires.Cursor = System.Windows.Forms.Cursors.Arrow;
			this.txtExpires.Location = new System.Drawing.Point(344, 36);
			this.txtExpires.Name = "txtExpires";
			this.txtExpires.ReadOnly = true;
			this.txtExpires.Size = new System.Drawing.Size(96, 20);
			this.txtExpires.TabIndex = 4;
			this.txtExpires.Text = "";
			// 
			// label5
			// 
			this.label5.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.label5.Location = new System.Drawing.Point(292, 36);
			this.label5.Name = "label5";
			this.label5.Size = new System.Drawing.Size(56, 20);
			this.label5.TabIndex = 8;
			this.label5.Text = "Expires";
			this.label5.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtSpecimenID
			// 
			this.txtSpecimenID.AccessibleDescription = "Specimen U I D";
			this.txtSpecimenID.AccessibleName = "Specimen U I D";
			this.txtSpecimenID.Anchor = ((System.Windows.Forms.AnchorStyles)(((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Left) 
				| System.Windows.Forms.AnchorStyles.Right)));
			this.txtSpecimenID.Cursor = System.Windows.Forms.Cursors.Arrow;
			this.txtSpecimenID.Location = new System.Drawing.Point(80, 36);
			this.txtSpecimenID.Name = "txtSpecimenID";
			this.txtSpecimenID.ReadOnly = true;
			this.txtSpecimenID.Size = new System.Drawing.Size(196, 20);
			this.txtSpecimenID.TabIndex = 2;
			this.txtSpecimenID.Text = "";
			// 
			// label6
			// 
			this.label6.Location = new System.Drawing.Point(8, 36);
			this.label6.Name = "label6";
			this.label6.Size = new System.Drawing.Size(80, 20);
			this.label6.TabIndex = 6;
			this.label6.Text = "Specimen UID";
			this.label6.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtABORh
			// 
			this.txtABORh.AccessibleDescription = "A B O R h";
			this.txtABORh.AccessibleName = "A B O R h";
			this.txtABORh.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.txtABORh.Cursor = System.Windows.Forms.Cursors.Arrow;
			this.txtABORh.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.txtABORh.Location = new System.Drawing.Point(500, 12);
			this.txtABORh.Name = "txtABORh";
			this.txtABORh.ReadOnly = true;
			this.txtABORh.Size = new System.Drawing.Size(112, 20);
			this.txtABORh.TabIndex = 5;
			this.txtABORh.Text = "";
			// 
			// lblABORh
			// 
			this.lblABORh.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.lblABORh.Location = new System.Drawing.Point(456, 12);
			this.lblABORh.Name = "lblABORh";
			this.lblABORh.Size = new System.Drawing.Size(48, 20);
			this.lblABORh.TabIndex = 4;
			this.lblABORh.Text = "ABO/Rh";
			this.lblABORh.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// txtPatientID
			// 
			this.txtPatientID.AccessibleDescription = "Patient I D";
			this.txtPatientID.AccessibleName = "Patient I D";
			this.txtPatientID.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.txtPatientID.Cursor = System.Windows.Forms.Cursors.Arrow;
			this.txtPatientID.Location = new System.Drawing.Point(344, 12);
			this.txtPatientID.Name = "txtPatientID";
			this.txtPatientID.ReadOnly = true;
			this.txtPatientID.Size = new System.Drawing.Size(96, 20);
			this.txtPatientID.TabIndex = 3;
			this.txtPatientID.Text = "";
			// 
			// lblSSN
			// 
			this.lblSSN.Anchor = ((System.Windows.Forms.AnchorStyles)((System.Windows.Forms.AnchorStyles.Top | System.Windows.Forms.AnchorStyles.Right)));
			this.lblSSN.Location = new System.Drawing.Point(292, 12);
			this.lblSSN.Name = "lblSSN";
			this.lblSSN.Size = new System.Drawing.Size(56, 20);
			this.lblSSN.TabIndex = 2;
			this.lblSSN.Text = "Patient ID";
			this.lblSSN.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// lblName
			// 
			this.lblName.Location = new System.Drawing.Point(8, 12);
			this.lblName.Name = "lblName";
			this.lblName.Size = new System.Drawing.Size(52, 20);
			this.lblName.TabIndex = 0;
			this.lblName.Text = "Name";
			this.lblName.TextAlign = System.Drawing.ContentAlignment.MiddleLeft;
			// 
			// grpImage
			// 
			this.grpImage.Controls.Add(this.pictureBox2);
			this.grpImage.Controls.Add(this.pictureBox1);
			this.grpImage.Location = new System.Drawing.Point(0, 0);
			this.grpImage.Name = "grpImage";
			this.grpImage.Size = new System.Drawing.Size(40, 64);
			this.grpImage.TabIndex = 1;
			this.grpImage.TabStop = false;
			// 
			// pictureBox2
			// 
			this.pictureBox2.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox2.Image")));
			this.pictureBox2.Location = new System.Drawing.Point(4, 32);
			this.pictureBox2.Name = "pictureBox2";
			this.pictureBox2.Size = new System.Drawing.Size(28, 24);
			this.pictureBox2.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
			this.pictureBox2.TabIndex = 1;
			this.pictureBox2.TabStop = false;
			// 
			// pictureBox1
			// 
			this.pictureBox1.Image = ((System.Drawing.Image)(resources.GetObject("pictureBox1.Image")));
			this.pictureBox1.Location = new System.Drawing.Point(4, 8);
			this.pictureBox1.Name = "pictureBox1";
			this.pictureBox1.Size = new System.Drawing.Size(28, 24);
			this.pictureBox1.SizeMode = System.Windows.Forms.PictureBoxSizeMode.StretchImage;
			this.pictureBox1.TabIndex = 0;
			this.pictureBox1.TabStop = false;
			// 
			// PatientSpecimenDisplayPanel
			// 
			this.Controls.Add(this.grpPatient);
			this.Controls.Add(this.grpImage);
			this.Font = new System.Drawing.Font("Arial", 8.25F, System.Drawing.FontStyle.Regular, System.Drawing.GraphicsUnit.Point, ((System.Byte)(0)));
			this.Name = "PatientSpecimenDisplayPanel";
			this.Size = new System.Drawing.Size(664, 64);
			this.grpPatient.ResumeLayout(false);
			this.grpImage.ResumeLayout(false);
			this.ResumeLayout(false);

		}
		#endregion

		#region Properties

		/// <summary>
		/// Get/Set Specimen
		/// </summary>
		public BOL.Specimen Specimen
		{
			get
			{
				return this._specimen;
			}
			set
			{
				this._specimen = value;
				//populate the Patient/Specimen info
				if (this._specimen != null)
				{
					this.SpecimenID = _specimen.SpecimenUid.ToString();
					this.Expires = Common.VBECSDateTime.FormatDateTimeString(_specimen.SpecimenExpirationDate);
					if (this._specimen.Patient != null)
					{
						this.patientInfoToolbar1.Patient = this._specimen.Patient;
						//
						this.AboRh = _specimen.Patient.AboRh.AboRHText;
						this.PatientName = _specimen.Patient.DisplayName;
						this.PatientID = _specimen.Patient.DisplayPatientID;//_specimen.Patient.SSN.ToString();		
						this.toolTip1.SetToolTip(this.txtABORh, this._specimen.Patient.GetPatientHistoricABORhForTooltip());
						this.picJustified.Visible = (_specimen.Patient.JustifiedAboRH);
					}
				}
			}
		}

		/// <summary>
		///  This property duplicates much of the Specimen property, but it is necassary because
		///  this control is used in instances where the patient may not have a specimen.
		/// </summary>
		public BOL.Patient Patient
		{
			get
			{
				return this._patient;
			}
			set
			{
				if (value!=null)
				{
					this._patient = value;
					this.patientInfoToolbar1.Patient = value;
					//
					this.AboRh = this._patient.AboRh.AboRHText;
					this.PatientName = this._patient.DisplayName;
					this.PatientID = this._patient.DisplayPatientID;
					this.toolTip1.SetToolTip(this.txtABORh,this._patient.GetPatientHistoricABORhForTooltip());
					this.picJustified.Visible = (this._patient.JustifiedAboRH);
				}
			}
		}

		/// <summary>
		/// Patient Toolbar
		/// </summary>
		public controls.PatientInfoToolbar PatientInfoToolbar
		{
			get
			{
				return this.patientInfoToolbar1;
			}
		}

		/// <summary>
		/// Indicates whether the SI (and) TR button is enabled
		/// </summary>
		[
		Category("Behavior"),
		Description("Indicates whether the SI & TR button is enabled"),
		DefaultValue(true),
		Bindable(false),
		Browsable(true),
		]
		public bool EnabledSIAndTRButton
		{
			get
			{
				return this.patientInfoToolbar1.EnabledSIAndTRButton;
			}
			set
			{
				this.patientInfoToolbar1.EnabledSIAndTRButton = value;
			}
		}

		/// <summary>
		/// Indicates whether the blood availability button is enabled
		/// </summary>
		[
		Category("Behavior"),
		Description("Indicates whether the blood availability button is enabled"),
		DefaultValue(true),
		Bindable(false),
		Browsable(true),
		]
		public bool EnabledBloodAvailButton
		{
			get
			{
				return this.patientInfoToolbar1.EnabledBloodAvailButton;
			}
			set
			{
				this.patientInfoToolbar1.EnabledBloodAvailButton = value;
			}
		}

		/// <summary>
		/// Indicates whether the Recent Orders button is enabled
		/// </summary>
		[
		Category("Behavior"),
		Description("Indicates whether the Recent Orders button is enabled"),
		DefaultValue(true),
		Bindable(false),
		Browsable(true),
		]
		public bool EnabledRecentOrdersButton
		{
			get
			{
				return this.patientInfoToolbar1.EnabledRecentOrdersButton;
			}
			set
			{
				this.patientInfoToolbar1.EnabledRecentOrdersButton = value;
			}
		}

		/// <summary>
		/// Indicates whether the Medication Profile button is enabled
		/// </summary>
		[
		Category("Behavior"),
		Description("Indicates whether the Medication Profile button is enabled"),
		DefaultValue(true),
		Bindable(false),
		Browsable(true),
		]
		public bool EnabledMedicationButton
		{
			get
			{
				return this.patientInfoToolbar1.EnabledMedicationButton;
			}
			set
			{
				this.patientInfoToolbar1.EnabledMedicationButton = value;
			}
		}

		/// <summary>
		/// Indicates whether the Recent Transfusions/Issues button is enabled
		/// </summary>
		[
		Category("Behavior"),
		Description("Indicates whether the Recent Transfusions/Issues button is enabled"),
		DefaultValue(true),
		Bindable(false),
		Browsable(true),
		]
		public bool EnabledRecentTransfusionsIssuesButton
		{
			get
			{
				return this.patientInfoToolbar1.EnabledRecentTransfusionsIssuesButton;
			}
			set
			{
				this.patientInfoToolbar1.EnabledRecentTransfusionsIssuesButton = value;
			}
		}

		/// <summary>
		/// Indicates whether the Transfusion Reaction History button is enabled
		/// </summary>
		[
		Category("Behavior"),
		Description("Indicates whether the Transfusion Reaction History button is enabled"),
		DefaultValue(true),
		Bindable(false),
		Browsable(true),
		]
		public bool EnabledTransfusionReactionHistoryButton
		{
			get
			{
				return this.patientInfoToolbar1.EnabledTransfusionReactionHistoryButton;
			}
			set
			{
				this.patientInfoToolbar1.EnabledTransfusionReactionHistoryButton = value;
			}
		}

		/// <summary>
		/// Get and set the value of patient name
		/// </summary>
		public string PatientName
		{
			get
			{
				return this.txtName.Text;
			}
			set
			{
				this.txtName.Text = value;
			}
		}

		/// <summary>
		/// Get and set the value of SpecimenID
		/// </summary>
		public string SpecimenID
		{
			get
			{
				return this.txtSpecimenID.Text;
			}
			set
			{
				this.txtSpecimenID.Text = value;
			}
		}

		/// <summary>
		/// Get and set the value of PatientID
		/// </summary>
		public string PatientID
		{
			get
			{
				return this.txtPatientID.Text;
			}
			set
			{
				this.txtPatientID.Text = value;
			}
		}

		/// <summary>
		/// Get and set the value of expiration date
		/// </summary>
		public string Expires
		{
			get
			{
				return this.txtExpires.Text;
			}
			set
			{
				this.txtExpires.Text = value;
			}
		}

		/// <summary>
		/// Get and set the value of ABORh
		/// </summary>
		public string AboRh
		{
			get
			{
				return this.txtABORh.Text;
			}
			set
			{
				this.txtABORh.Text = value;
			}
		}

		#endregion


		#region EventHandlers

		/// <summary>
		/// Event that handles the click on special instructions and transfusion requirements button
		/// </summary>
		public event EventHandler SIAndTRClick
		{
			add
			{
				onSIAndTRClick += value;
			}
			remove
			{
				onSIAndTRClick -= value;
			}
		}

		/// <summary>
		/// Event that handles click on the blood availability button
		/// </summary>
		public event EventHandler BloodAvailClick
		{
			add
			{
				onBloodAvailClick += value;
			}
			remove
			{
				onBloodAvailClick -= value;
			}
		}

		/// <summary>
		/// Event that handles click on the display patient VBECS data
		/// </summary>
		public event EventHandler VbecsInfoClick
		{
			add
			{
				onVbecsInfoClick += value;
			}
			remove
			{
				onVbecsInfoClick -= value;
			}
		}

		/// <summary>
		/// Event that handles click on the patient medications button
		/// </summary>
		public event EventHandler MedicationsClick
		{
			add
			{
				onMedicationsClick += value;
			}
			remove
			{
				onMedicationsClick -= value;
			}
		}

		/// <summary>
		/// Event that handles click on the transfusion history button
		/// </summary>
		public event EventHandler TransHistoryClick
		{
			add
			{
				onTransHistoryClick += value;
			}
			remove
			{
				onTransHistoryClick -= value;
			}
		}

		/// <summary>
		/// Event that handles click on the patient clinical data button
		/// </summary>
		public event EventHandler ClinicalInfoClick
		{
			add
			{
				onClinicalInfoClick += value;
			}
			remove
			{
				onClinicalInfoClick -= value;
			}
		}

		/// <summary>
		/// Calls the event when special instructions and patient transfusion requirements button is being clicked
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnSpecialInstructions_Click(object sender, System.EventArgs e)
		{
			this.OnUserActivity();

			if (onSIAndTRClick != null)
			{
				onSIAndTRClick(sender,e);
			}
		}

		/// <summary>
		/// Calls the event when blood availability button is being clicked
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnBloodAvailability_Click(object sender, System.EventArgs e)
		{
			this.OnUserActivity();

			if (onBloodAvailClick != null)
			{
				onBloodAvailClick(sender,e);
			}
		}

		/// <summary>
		/// Calls the event when patient VBECS data button is being clicked
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnPatientInfo_Click(object sender, System.EventArgs e)
		{
			this.OnUserActivity();

			if (onVbecsInfoClick != null)
			{
				onVbecsInfoClick(sender,e);
			}
		}

		/// <summary>
		/// Calls the event when patient current medications button is being clicked
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnCurrentMeds_Click(object sender, System.EventArgs e)
		{
			this.OnUserActivity();

			if (onMedicationsClick != null)
			{
				onMedicationsClick(sender,e);
			}
		}

		/// <summary>
		/// Calls the event when patient transfusion history button is being clicked
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnTransfusionHistory_Click(object sender, System.EventArgs e)
		{
			this.OnUserActivity();

			if (onTransHistoryClick != null)
			{
				onTransHistoryClick(sender,e);
			}
		}

		/// <summary>
		/// Calls the event when patient clinical data button is being clicked
		/// </summary>
		/// <param name="sender"></param>
		/// <param name="e"></param>
		private void btnClinicalData_Click(object sender, System.EventArgs e)
		{
			this.OnUserActivity();

			if (onClinicalInfoClick != null)
			{
				onClinicalInfoClick(sender,e);
			}
		}

		/// <summary>
		/// **** 508 Compliance ***
		/// </summary>
		/// <returns></returns>
		public string GetErrorMessagesFor508()
		{
			string textToSpeak = string.Empty;
			if(this.picJustified.Visible)
			{
				textToSpeak = "The patient has a history of  justified ABO/Rh change";
			}

			return textToSpeak;
		}

		#endregion






	}
}
